/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.misc.Misc;
import xaero.map.region.MapBlock;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayManager;

public class OverlayBuilder {
    private static final int MAX_OVERLAYS = 10;
    private Overlay[] overlayBuildingSet;
    private int currentOverlayIndex;
    private OverlayManager overlayManager;
    private TextureAtlasSprite prevIcon;
    private int overlayBiome;

    public OverlayBuilder(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
        this.overlayBuildingSet = new Overlay[10];
        for (int i = 0; i < this.overlayBuildingSet.length; ++i) {
            this.overlayBuildingSet[i] = new Overlay(0, 0, 0, 0.0f, 0, false);
        }
        this.currentOverlayIndex = -1;
    }

    public void startBuilding() {
        this.currentOverlayIndex = -1;
        this.setOverlayBiome(-1);
    }

    public void build(int state, int[] biome, int opacity, byte light, World world, MapProcessor mapProcessor, BlockPos mutableBlockPos, int biomeId, BlockStateColorTypeCache colorTypeCache, BiomeInfoSupplier biomeSupplier) {
        Overlay currentOverlay = this.getCurrentOverlay();
        Overlay nextOverlay = null;
        if (this.currentOverlayIndex < this.overlayBuildingSet.length - 1) {
            nextOverlay = this.overlayBuildingSet[this.currentOverlayIndex + 1];
        }
        TextureAtlasSprite icon = null;
        boolean changed = false;
        if (currentOverlay == null || currentOverlay.getState() != state) {
            icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(Misc.getStateById(state));
            boolean bl = changed = icon != this.prevIcon;
        }
        if (nextOverlay != null && (currentOverlay == null || changed)) {
            IBlockState s = Misc.getStateById(state);
            float transparency = s.func_177230_c() instanceof BlockLiquid ? 0.66f : (s.func_177230_c() instanceof BlockIce ? 0.83f : 0.5f);
            boolean glowing = false;
            try {
                glowing = mapProcessor.getMapWriter().isGlowing(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (biomeSupplier != null) {
                biomeSupplier.getBiomeInfo(colorTypeCache, world, s, mutableBlockPos, biome, biomeId);
                biomeId = biome[1];
            }
            if (this.getOverlayBiome() == -1) {
                this.setOverlayBiome(biomeId);
            }
            nextOverlay.write(state, biome[0], biome[2], transparency, light, glowing);
            currentOverlay = nextOverlay;
            ++this.currentOverlayIndex;
        }
        currentOverlay.increaseOpacity(opacity);
        if (changed) {
            this.prevIcon = icon;
        }
    }

    public boolean isEmpty() {
        return this.currentOverlayIndex < 0;
    }

    public Overlay getCurrentOverlay() {
        Overlay currentOverlay = null;
        if (this.currentOverlayIndex >= 0) {
            currentOverlay = this.overlayBuildingSet[this.currentOverlayIndex];
        }
        return currentOverlay;
    }

    public void finishBuilding(MapBlock block) {
        for (int i = 0; i <= this.currentOverlayIndex; ++i) {
            Overlay o = this.overlayBuildingSet[i];
            Overlay original = this.overlayManager.getOriginal(o);
            if (o == original) {
                this.overlayBuildingSet[i] = new Overlay(0, 0, 0, 0.0f, 0, false);
            }
            block.addOverlay(original);
        }
    }

    public int getOverlayBiome() {
        return this.overlayBiome;
    }

    public void setOverlayBiome(int overlayBiome) {
        this.overlayBiome = overlayBiome;
    }
}

